﻿using log4net;
using Microsoft.AspNetCore.Mvc;
using Moq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Controllers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;
using Xunit;

namespace VA.PPMS.IWS.Api.Unit.Test
{
    public class CcnInitialDocRefControllerTests
    {
        [Fact]
        public void TestCcnInitialDocRefReturns201()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.Created)));

            var controller = new CcnInitialDocRefController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'id': '31c54d42-174c-4f27-a7e7-9a45271b5613','resourceType': 'DocumentReference','content': [{'attachment': {'contentType': 'text/plain','url': 'testing.com/api/1234'}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(201, statusCodeResult.StatusCode);
            Assert.Equal("Successfully processed.", statusCodeResult.Value);
        }

        [Fact]
        public void TestCcnInitialDocRefNoUrlReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));
            
            var controller = new CcnInitialDocRefController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'id': '31c54d42-174c-4f27-a7e7-9a45271b5613','resourceType': 'DocumentReference','content': [{'attachment': {'contentType': 'text/plain','url': ''}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
            Assert.Equal("Bundle is missing data required to process the transaction", statusCodeResult.Value);
        }

        [Fact]
        public void TestCcnInitialDocRefInvalidDocumentReferenceReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new CcnInitialDocRefController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
            Assert.Equal("DocumentReference payload is invalid", statusCodeResult.Value);
        }

        [Fact]
        public void TestCcnInitialDocRefPostToFunctionErrorReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.PostAsync(It.IsAny<string>(), It.IsAny<DasMessage>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new CcnInitialDocRefController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            const string fhirMessage = "{'id': '31c54d42-174c-4f27-a7e7-9a45271b5613','resourceType': 'DocumentReference','content': [{'attachment': {'contentType': 'text/plain','url': 'testing.com/api/1234'}}]}";

            // Act
            var results = controller.Post(fhirMessage);
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
        }
    }
}